//
// SDScrollerAccessoryScrollView.h
//
// (C) Copyright 1989-1999 Andrew C. Stone and Stone Design Corp
// All rights reserved. You can use this code, but please leave credit.
//

#import <AppKit/AppKit.h>

extern NSString *MCVisibleRectDidChangeNotification;

@interface MCScrollView : NSScrollView
{
   BOOL onRightSide;
   BOOL atTop;
   IBOutlet NSView *horizontalAccessory;
   IBOutlet NSView *verticalAccessory;
}

- (void)setHorizontalScrollerAccessory:(id)sender
onRightSide:(BOOL)rightSide;
- (void)setVerticalScrollerAccessory:(id)sender atTop:(BOOL)top;

- (void)setHorizontalScrollerAccessory:(id)sender;
- (void)setVerticalScrollerAccessory:(id)sender;

// by default, at left, and at top
- (void)setVerticalScrollerAccessoryIsAtTop:(BOOL)atTop;
- (void)setHorizontalAccessoryIsOnRightSide:(BOOL)rightSide;

@end

